package ibase.webitm.ejb.vhb.msq1;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;


public class ApprovedRateOne extends ValidatorEJB {
    String usersiteCode = "";
    E12GenericUtility genericUtility = new E12GenericUtility();

    public ApprovedRateOne(UserInfoBean userInfoBean) {
        setUserInfo(userInfoBean);
        userInfoBean = getUserInfo();
        usersiteCode = userInfoBean.getSiteCode();
        BaseLogger.log("3", getUserInfo(), null, "usersiteCode : " + usersiteCode);
        BaseLogger.log("3", getUserInfo(), null, "Class Call Khushal ");
    }

    public HashMap<String, ArrayList<String>> getLastThreeQuotationRates(String itemCode, String quotNo1) throws ITMException, SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LinkedHashMap<String, ArrayList<String>> quotationRatesMap = new LinkedHashMap<>();
        int count = 0;

        String sql = "SELECT cust_code, quot_no, created_date, item_code, approved_rate, quantity FROM item_rate_hist WHERE item_code = ? AND quot_no = ? AND created_date IS NOT NULL ORDER BY created_date DESC limit 1 ";

        try {
            BaseLogger.log("3", getUserInfo(), null, "Fetching last 1 quotation rate for item_code: " + itemCode);
            BaseLogger.log("3", getUserInfo(), null, "Fetching quotation no: " + quotNo1);

            conn = getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, itemCode);
            pstmt.setString(2, quotNo1);
            rs = pstmt.executeQuery();

            while (rs.next()) {
                ArrayList<String> quotationDetails = new ArrayList<>();
                
                String customerCode = checkNull(rs.getString("cust_code"));
                String quotNo = checkNull(rs.getString("quot_no"));
                String addDate = checkNull(rs.getString("created_date"));
                String itemCodeResult = checkNull(rs.getString("item_code"));
                String aprvRate = checkNull(rs.getString("approved_rate"));
                String quantity = checkNull(rs.getString("quantity"));

                SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
                java.util.Date addDateUtil = dbFormat.parse(addDate);
                SimpleDateFormat displayFormat = new SimpleDateFormat("dd/MM/yy");
                String formattedAddDate = displayFormat.format(addDateUtil);

                quotationDetails.add(customerCode);
                quotationDetails.add(quotNo);
                quotationDetails.add(formattedAddDate);
                quotationDetails.add(itemCodeResult);
                quotationDetails.add(aprvRate);
                quotationDetails.add(quantity);

                quotationRatesMap.put(String.valueOf(count), quotationDetails);
                count++;
            }

        } catch (Exception e) {
            BaseLogger.log("3", getUserInfo(), null, "Exception in getLastQuotationRate: " + e.getMessage());
            throw new ITMException(e);
        } finally {
            if (rs != null) rs.close();
            if (pstmt != null) pstmt.close();
            if (conn != null) conn.close();
        }

        return quotationRatesMap;
    }

    private String checkNull(String str) {
        return (str == null) ? "" : str;
    }
}
